#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.Common.UnitTests
{

	
	


	[TestFixture]
	public class Common_VbecsConfigurationException : BaseTest 
	{
		private const string TestMessage = "Test message";
		private static readonly Exception _testInnerException = new Exception();

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull( new VbecsConfigurationException() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_String_Pass()
		{
			Assert.IsNotNull( new VbecsConfigurationException( TestMessage ) );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Fail()
		{
		}

		[Test]
		public void Ctor_String_Exc_Pass()
		{
			Assert.IsNotNull( new VbecsConfigurationException( TestMessage, _testInnerException ) );
		}

		[Test]
		public void Ctor_String_Exc_Pass2()
		{
			Assert.AreEqual( TestMessage, new VbecsConfigurationException( TestMessage, _testInnerException ).Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Exc_Fail()
		{
		}
	}
}

#endif
